﻿/*
VERSION:		1.2
	1.1			Use === instead for exact matching.
	1.2			Adjust != checking to be more strict.  Only ("") (false) and (null) are considered equal to (undefined).

USAGE:
	#include "functions/checkFlag.as"
	if(  checkFlag("merf>10", allFlags_obj)  )
		// do stuff
*/
function checkFlag( spriteFlag, flagRoot )
{
	var TRACE_THIS = false;
	#include "getPathValue.as"
	// requiring a non-existant condition = fail
	if(spriteFlag === undefined)		return false;
	
	var output = true;			// returns boolean "false" when a flag fails a test
	var flagParts_array = getFlagParts( spriteFlag );
	var variable = flagParts_array[0];
	var operation = flagParts_array[1];
	var compareToValue = flagParts_array[2];
	//var compareToValue = nestedEval( flagParts_array[2], "RAM", "RAM" );
	
	// convert compareToValue into likely datatype
	// // number
	if( isNaN(compareToValue)==false )
		compareToValue = Number(compareToValue);
	// // boolean
	if( compareToValue === "true" )
		compareToValue = true;
	if( compareToValue === "false" )
		compareToValue = false;
	// // undefined
	if( compareToValue === "undefined" )
		compareToValue = undefined;
	if( compareToValue === null )
		compareToValue = undefined;
	// // string
	// already a string by default
	
	// separate variable name from variable path
	/*
	var endAt = variable.lastIndexOf(".");
	if( endAt != -1 )
	{// if:  there is an object path
		var flagPath = variable.substr(0, endAt);			// myObj.anotherObject
		var flagName = variable.substr( endAt+1 );		// myVar
		var flagPath = "flagRoot."+flagPath;					// flagRoot.myObj.anotherObject
	}// if:  there is an object path
	else
	{// if:  there are no preceeding objects
		var flagName = variable;
		var flagPath = "flagRoot";
	}// if:  there are no preceeding objects
	//var currentValue = eval(flagPath+"."+flagName);
	*/
	var currentValue = getPathValue( variable, flagRoot );
	if( currentValue === null)
		currentValue = undefined;
	
	if(TRACE_THIS)		trace("checkFlag: (" + spriteFlag + ")  (" + flagParts_array + ")");
	
	// check specified contents, in the specified ways
	switch( operation )
	{
		case "!":
			output = ( currentValue === undefined  ||  currentValue === false );		// these values return as true
			//trace("  currentValue: "+currentValue+"  ("+typeof(currentValue)+")  =  "+output);
		break;
		case "=":
			output = ( currentValue === compareToValue );
		break;
		case "!=":
			// if(TRACE_THIS)		trace(" currentValue: " + currentValue);
			// if(TRACE_THIS)		trace(" compareToValue: " + compareToValue);
			// consider "myVar != undefined" to be TRUE when   myVar actually equals "false"
			// if( !Boolean(currentValue) && !Boolean(compareToValue) ){
			if( currentValue === false && !Boolean(compareToValue) ){
				currentValue = false;
				compareToValue = false;
			}
			// consider "myVar != undefined" to be TRUE when   myVar actually equals ""
			if( currentValue === "" && !Boolean(compareToValue) ){
				currentValue = false;
				compareToValue = false;
			}
			// if(TRACE_THIS)		trace("  currentValue: " + currentValue);
			// if(TRACE_THIS)		trace("  compareToValue: " + compareToValue);
			output = ( currentValue !== compareToValue );
		break;
		case "<":
			output = ( currentValue < compareToValue );
			if(currentValue === undefined){	output=false		};					// undefined normally returns true
			if(typeof(currentValue) == "string"){	output=false		};		// strings normally return true
		break;
		case ">":
			output = ( currentValue > compareToValue );
			if(currentValue === undefined){	output=false		};					// undefined normally returns true
			if(typeof(currentValue) == "string"){	output=false		};		// strings normally return true
		break;
		case "<=":
			output = ( currentValue <= compareToValue );
			if(currentValue === undefined){	output=false		};					// undefined normally returns true
			if(typeof(currentValue) == "string"){	output=false		};		// strings normally return true
		break;
		case ">=":
			output = ( currentValue >= compareToValue );
			if(currentValue === undefined){	output=false		};					// undefined normally returns true
			if(typeof(currentValue) == "string"){	output=false		};		// strings normally return true
		break;
	}// case:  operation
	if(TRACE_THIS)		trace("  condition is: " + output);
	
//		trace("\t\t "+output+" ("+currentValue+" "+operation+" "+compareToValue+")" );
	return output;
	
	
	
	// _______________________________________________________________________________
	function getFlagParts( flag )
	{// convert "myFlag" to "myFlag != undefined"		"!myFlag" to "myFlag = undefined"		"myFlag>2" to "myFlag > 2"
		var parts_array = [];
		
		// remove space from beginning of flag
		var firstChar = flag.charAt(0);
		while(firstChar==" "){
			flag = flag.substr(1);		// chop off first character
			firstChar = flag.charAt(0);
		}// while:  space exists at the beginning
		
		
		// remove space from end of flag
		var lastChar = flag.charAt( flag.length-1 );
		while(lastChar==" "){
			flag = flag.substr(0, flag.length-1);		// chop off last character
			lastChar = flag.charAt( flag.length-1 );
		}// while:  space exists at the end
		
		
		// catch:  !myFlag
		if( flag.charAt(0) == "!" ){
			flag = flag.substr(1)+"!";
			var endAt = flag.indexOf("!");
			var startAt = endAt+1;
		}// if:  flag starts with !
		else if( flag.indexOf("!=") != -1 ){
			var endAt = flag.indexOf("!=");
			var startAt = endAt+2;
		}
		else if( flag.indexOf("<=") != -1 ){
			var endAt = flag.indexOf("<=");
			var startAt = endAt+2;
		}
		else if( flag.indexOf(">=") != -1 ){
			var endAt = flag.indexOf(">=");
			var startAt = endAt+2;
		}
		else if( flag.indexOf("<") != -1 ){
			var endAt = flag.indexOf("<");
			var startAt = endAt+1;
		}
		else if( flag.indexOf(">") != -1 ){
			var endAt = flag.indexOf(">");
			var startAt = endAt+1;
		}
		else if( flag.indexOf("=") != -1 ){
			var endAt = flag.indexOf("=");
			var startAt = endAt+1;
		}
		else{// if:  there's no operator
			var endAt = flag.length;
			flag = flag+"!=undefined"
			var startAt = endAt+2;
		}// if:  there's no operator
		
		parts_array.push(flag.substr( 0, endAt ));					// [0]	myFlag
		parts_array.push(flag.substring( endAt, startAt ));	// [1]	!=
		parts_array.push(flag.substr( startAt ));						// [2]	"merf"
		
		// remove space from end of flag name
		var lastChar = parts_array[0].charAt( parts_array[0].length-1 );
		while(lastChar==" "){
			parts_array[0] = parts_array[0].substr(0, parts_array[0].length-1);		// chop off last character
			lastChar = parts_array[0].charAt( parts_array[0].length-1 );
		}// while:  space exists at the end
		// remove space from beginning of value
		var firstChar = parts_array[2].charAt(0);
		while(firstChar==" "){
			parts_array[2] = parts_array[2].substr(1);		// chop off first character
			firstChar = parts_array[2].charAt(0);
		}// while:  space exists at the beginning
		
		return parts_array;
	}// getFlagParts()
}// checkFlag()